/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.analysis.dpManager;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.rmi.ConnectException;
import java.util.Hashtable;

public class PHashtable
extends Hashtable {
    public static final String configDirectory = "config";
    private static final int MAX_INVALIDS = 15;
    private static final int MIN_FILE_SIZE = 100000;
    private int numInvalids;
    private RandomAccessFile theRAF;
    private String filename;
    private Hashtable offsetTable = new Hashtable();
    private FileOutputStream ostream;
    private ObjectOutputStream theOOS;
    private static final String PARSECHAR = ":`:";

    public PHashtable(String string) {
        File file = new File(configDirectory);
        if (!file.isDirectory()) {
            file.mkdir();
        }
        this.filename = "config/" + string;
        this.restore();
    }

    public PHashtable(String string, String string2) {
        File file = new File(string);
        if (!file.isDirectory()) {
            file.mkdir();
        }
        this.filename = String.valueOf(string) + "/" + string2;
        this.restore();
    }

    public static String createKey(String string, String string2) {
        return String.valueOf(string) + PARSECHAR + string2;
    }

    public static String createKey(String string, String string2, String string3) {
        return String.valueOf(string) + PARSECHAR + string2 + PARSECHAR + string3;
    }

    public static String[] parseKey(String string) {
        String[] stringArray = new String[2];
        int n = string.indexOf(PARSECHAR);
        stringArray[0] = string.substring(0, n - 1);
        stringArray[1] = string.substring(n + PARSECHAR.length());
        return stringArray;
    }

    private synchronized boolean backup() throws IOException {
        boolean bl = true;
        if (this.theRAF != null) {
            this.theRAF.close();
        }
        if (this.theOOS != null) {
            this.theOOS.close();
        }
        File file = new File(String.valueOf(this.filename) + ".db");
        File file2 = new File(String.valueOf(this.filename) + ".db" + ".bak");
        File file3 = new File(String.valueOf(this.filename) + ".tb");
        File file4 = new File(String.valueOf(this.filename) + ".tb" + ".bak");
        if (!file3.exists() || !file.exists()) {
            bl = false;
        } else {
            file2.delete();
            file4.delete();
            file3.renameTo(file4);
            file.renameTo(file2);
        }
        this.theRAF = new RandomAccessFile(String.valueOf(this.filename) + ".tb", "rw");
        this.ostream = new FileOutputStream(String.valueOf(this.filename) + ".db");
        this.theOOS = new ObjectOutputStream(this.ostream);
        return bl;
    }

    protected void finalize() {
        this.close();
    }

    public void close() {
        try {
            if (this.theRAF != null) {
                this.theRAF.close();
            }
            if (this.ostream != null) {
                this.ostream.close();
            }
            if (this.theOOS != null) {
                this.theOOS.close();
                return;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public synchronized void restore() {
        try {
            if (this.backup()) {
                System.err.println("Restoring table from file: " + this.filename);
                long l = System.currentTimeMillis();
                FileInputStream fileInputStream = new FileInputStream(String.valueOf(this.filename) + ".db" + ".bak");
                ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
                RandomAccessFile randomAccessFile = new RandomAccessFile(String.valueOf(this.filename) + ".tb" + ".bak", "r");
                long l2 = randomAccessFile.length();
                while (randomAccessFile.getFilePointer() != l2) {
                    boolean bl = randomAccessFile.readBoolean();
                    Object object = objectInputStream.readObject();
                    Object object2 = objectInputStream.readObject();
                    if (!bl) continue;
                    this.put(object, object2);
                }
                randomAccessFile.close();
                objectInputStream.close();
                System.out.println("Restoration took " + (System.currentTimeMillis() - l) + " ms");
                return;
            }
            System.err.println("No data to restore for : " + this.filename);
            return;
        }
        catch (ConnectException connectException) {
            System.out.println("Tried to restore a remote reference, but did not succeed...");
            return;
        }
        catch (Exception exception) {
            System.out.println("PHashtable: an exception occurred:");
            exception.printStackTrace();
            return;
        }
    }

    public String dumpStats() {
        StringBuffer stringBuffer = new StringBuffer("PHhashtable Stats");
        stringBuffer.append("\nFilename: ");
        stringBuffer.append(this.filename);
        stringBuffer.append("\nsize: ");
        stringBuffer.append(this.size());
        stringBuffer.append("\ninvalids: ");
        stringBuffer.append(this.numInvalids);
        stringBuffer.append("\nfile size: ");
        File file = new File(String.valueOf(this.filename) + ".db");
        stringBuffer.append(file.length());
        return stringBuffer.toString();
    }

    public synchronized void clear() {
        File file;
        super.clear();
        try {
            if (this.theRAF != null) {
                this.theRAF.close();
            }
            if (this.theOOS != null) {
                this.theOOS.close();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if ((file = new File(String.valueOf(this.filename) + ".tb")).exists()) {
            file.delete();
        }
        if ((file = new File(String.valueOf(this.filename) + ".db")).exists()) {
            file.delete();
        }
        try {
            this.theRAF = new RandomAccessFile(String.valueOf(this.filename) + ".tb", "rw");
            this.ostream = new FileOutputStream(String.valueOf(this.filename) + ".db");
            this.theOOS = new ObjectOutputStream(this.ostream);
            return;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
    }

    public synchronized Object remove(Object object) {
        Object var2_2;
        block3: {
            var2_2 = null;
            File file = new File(String.valueOf(this.filename) + ".db");
            if (object == null) break block3;
            var2_2 = super.remove(object);
            try {
                long l = this.theRAF.getFilePointer();
                this.theRAF.seek((Long)this.offsetTable.get(object));
                this.theRAF.writeBoolean(false);
                this.theRAF.seek(l);
                if (++this.numInvalids > 15 && file.length() > 100000L) {
                    System.out.println("PHashtable : remove : compacting (size/invalids " + this.size() + "/" + this.numInvalids + ")");
                    this.numInvalids = 0;
                    this.clear();
                    this.offsetTable = new Hashtable();
                    this.restore();
                }
            }
            catch (Exception exception) {
                var2_2 = null;
                System.out.println("PHashtable:remove: an exception occurred:");
                exception.printStackTrace();
            }
        }
        return var2_2;
    }

    public synchronized Object put(Object object, Object object2) {
        Object object3;
        block3: {
            object3 = null;
            if (object == null || object2 == null) break block3;
            try {
                if (super.get(object) != null) {
                    this.remove(object);
                    this.theOOS.reset();
                }
                this.offsetTable.put(object, new Long(this.theRAF.getFilePointer()));
                this.theRAF.writeBoolean(true);
                this.theOOS.writeObject(object);
                this.theOOS.writeObject(object2);
                this.theOOS.flush();
                object3 = super.put(object, object2);
            }
            catch (Exception exception) {
                System.out.println("an exception occurred:");
                exception.printStackTrace();
            }
        }
        return object3;
    }

    public static void main(String[] stringArray) {
        int n = 0;
        while (n < 10) {
            PHashtable pHashtable = new PHashtable("test", "tempTable");
            pHashtable.put(new Integer(n), new Integer(n));
            pHashtable.close();
            ++n;
        }
    }
}

